# CigarFinder.eu — MVP (cPanel / Passenger)

Este pacote contém um **MVP** de comparador de preços de charutos:
- **Flask (Python)** com Passenger (cPanel)
- **SQLite** para armazenar preços
- **Scraper diário** (cron) para Hacico (≤10€; 70–150mm)

> **Aviso legal:** verifica os Termos de Utilização do(s) site(s) e usa scraping de forma responsável (limita a frequência; respeita robots.txt). Este MVP é apenas para demonstração/uso pessoal.

## 1) Instalação em cPanel (Python App / Passenger)

1. No cPanel, abre **Setup Python App** (ou “Application Manager” → **Passenger**).
2. Cria uma nova app Python (Python 3.10+). Escolhe como **Application root** a pasta onde vais colocar estes ficheiros (ex.: `/home/USER/cigarfinder_mvp`).
3. Anota o *path* do **virtualenv** criado pelo cPanel (ex.: `/home/USER/virtualenv/cigarfinder_mvp/3.10/bin/activate`).
4. Faz **Upload** de todos os ficheiros deste pacote para a pasta da app.
5. No ecrã da app, adiciona as dependências: abre o terminal do cPanel e executa:
   ```bash
   source /home/USER/virtualenv/cigarfinder_mvp/3.10/bin/activate
   pip install -r requirements.txt
   ```
6. Garante que existe o ficheiro **passenger_wsgi.py** (incluído neste pacote). É a *entrypoint* do Passenger.
7. Clica **Restart** na app no cPanel.

Se tudo correu bem, acede ao domínio/subdomínio configurado (ex.: `https://cigarfinder.eu/`).

## 2) Preparar a BD (primeira vez)
No terminal do cPanel:
```bash
source /home/USER/virtualenv/cigarfinder_mvp/3.10/bin/activate
python db_init.py
```

## 3) Scraper diário (cron)
Cria uma **tarefa CRON** diária (por ex. 07:30):
```
30 7 * * * source /home/USER/virtualenv/cigarfinder_mvp/3.10/bin/activate && cd /home/USER/cigarfinder_mvp && /home/USER/virtualenv/cigarfinder_mvp/3.10/bin/python scraper_hacico.py >> logs/scraper.log 2>&1
```
> Cria a pasta `logs/` se necessário.

## 4) Como usar
- Vai à página principal → pesquisa pelo nome do charuto (“Robusto”, “Cohiba”, “Schizo”).
- Ordena por preço/nome/loja.

## 5) Adicionar novas lojas
Replica o `scraper_hacico.py` para `scraper_<loja>.py`:
- Ajusta a URL e os *selectors* CSS.
- Insere na mesma tabela `products` com `shop` = nome da loja.
- Agenda novos *cron jobs*.

## 6) Segurança & performance
- Mantém o site atrás de HTTPS (ativar SSL/TLS no cPanel).
- Se o tráfego crescer, considera mover a BD para MariaDB.
- Limita o nº de resultados (no `app.py` já há limite de 500).

Boa sorte! 🚀
